/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties;

import filenet.sim.toolkit.designer.properties.IVWSIMPropertyChangeListener;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyChangeEvent;
import filenet.vw.base.VWDebug;
import javax.swing.event.EventListenerList;

public class VWSIMPropertyChangeNotifier {
    private EventListenerList m_propertyChangeListeners = null;

    public void addPropertyChangeListener(IVWSIMPropertyChangeListener listener) {
        if (this.m_propertyChangeListeners == null) {
            this.m_propertyChangeListeners = new EventListenerList();
        }
        this.removePropertyChangeListener(listener);
        this.m_propertyChangeListeners.add(IVWSIMPropertyChangeListener.class, listener);
    }

    public void removePropertyChangeListener(IVWSIMPropertyChangeListener listener) {
        if (this.m_propertyChangeListeners != null) {
            this.m_propertyChangeListeners.remove(IVWSIMPropertyChangeListener.class, listener);
        }
    }

    public void notifyPropertyChange(Object source, int nEventId) {
        this.notifyPropertyChange(source, nEventId, null);
    }

    public void notifyPropertyChange(Object source, int nEventId, Object obj) {
        try {
            if (this.m_propertyChangeListeners != null && this.m_propertyChangeListeners.getListenerCount() > 0) {
                VWSIMPropertyChangeEvent event = new VWSIMPropertyChangeEvent(source, nEventId, obj);
                Object[] listeners = this.m_propertyChangeListeners.getListenerList();
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != IVWSIMPropertyChangeListener.class) continue;
                    ((IVWSIMPropertyChangeListener)listeners[i + 1]).propertyDataChanged(event);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseReferences() {
        this.m_propertyChangeListeners = null;
    }
}

